/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.linker;

import filenet.vw.apps.linker.IVWLinkerTable;
import filenet.vw.apps.linker.resources.VWResource;
import filenet.vw.idm.toolkit.IVWIDMDocument;
import filenet.vw.idm.toolkit.IVWIDMLibrary;
import filenet.vw.idm.toolkit.IVWIDMLink;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;

public class VWLinkerWFTableModel
extends DefaultTableModel
implements IVWLinkerTable {
    public static final int COLUMN_LINK = 0;
    public static final int COLUMN_TYPE = 1;
    public static final int COLUMN_DOC_NAME = 2;
    public static final int COLUMN_VERSION = 3;
    public static final int COLUMN_SUBJECT = 4;
    public static final int COLUMN_LAUNCH_TYPE = 5;
    public IVWIDMLibrary m_library = null;

    public VWLinkerWFTableModel() {
        this.addColumn(VWResource.LinkName);
        this.addColumn(VWResource.Type);
        this.addColumn(VWResource.DocClassName);
        this.addColumn(VWResource.Version);
        this.addColumn(VWResource.WorkflowSubject);
        this.addColumn(VWResource.LaunchType);
    }

    public DefaultTableModel getDefaultTableModel() {
        return this;
    }

    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public void addLink(IVWIDMLink link) throws Exception {
        if (link == null) {
            return;
        }
        if (this.m_library == null) {
            throw new Exception("VWLinkerWFTableModel: m_library is null");
        }
        IVWIDMDocument doc = null;
        try {
            String docId = link.getDocumentId();
            if (docId == null) {
                return;
            }
            doc = this.m_library.getDocument(docId);
            if (doc == null) {
                return;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        Vector<Object> aRow = new Vector<Object>();
        aRow.addElement(link);
        int linkType = link.getLinkType();
        if (linkType == 1) {
            aRow.addElement(VWResource.Document);
            aRow.addElement(doc.getLabel());
        } else {
            aRow.addElement(VWResource.DocumentClass);
            aRow.addElement(link.getDocumentClass());
        }
        String wfId = link.getWflDocID();
        aRow.addElement(wfId.substring(wfId.lastIndexOf(58) + 1));
        aRow.addElement(link.getSubject());
        String eventType = null;
        switch (link.getEventType()) {
            case 0: {
                eventType = VWResource.Manual;
                break;
            }
            case 2: {
                eventType = VWResource.OnAdd;
                break;
            }
            case 1: {
                eventType = VWResource.OnCheckin;
            }
        }
        aRow.addElement(eventType);
        this.addRow(aRow);
    }

    public IVWIDMLink getLink(int row) throws Exception {
        IVWIDMLink aLink = null;
        aLink = (IVWIDMLink)this.getValueAt(row, 0);
        return aLink;
    }

    public IVWIDMLibrary getLibrary() {
        return this.m_library;
    }

    public void setLibrary(IVWIDMLibrary lib) {
        this.m_library = lib;
    }

    public void setWfTitle(String title, int row) {
    }

    public void setWFVersion(String wfDefId, int row) {
        String wfVer = wfDefId.substring(wfDefId.lastIndexOf(58) + 1);
        this.setValueAt(wfVer, row, 3);
    }

    public void setDocName(String docName, int row) {
        this.setValueAt(docName, row, 2);
    }

    public void setLaunchType(int type, int row) {
        String eventType = null;
        switch (type) {
            case 0: {
                eventType = VWResource.Manual;
                break;
            }
            case 2: {
                eventType = VWResource.OnAdd;
                break;
            }
            case 1: {
                eventType = VWResource.OnCheckin;
            }
        }
        this.setValueAt(eventType, row, 5);
    }

    public void setSubject(String subject, int row) {
        this.setValueAt(subject, row, 4);
    }
}

